const express = require("express");
const app = express();
// **NEW** use the Azure Port or 3000 if local
const port = process.env.PORT || 3000;

const students = [
  { id:  1, name: "Anna",    course: "Computer Science" },
  { id:  2, name: "Susi",    course: "Mathematics" },
  { id:  3, name: "Fritz",   course: "English" },
  { id:  4, name: "Andrea",  course: "Mathematics" },
  { id:  5, name: "Thomas",  course: "German" },
  { id:  6, name: "Verena",  course: "Mathematics" },
  { id:  7, name: "Marion",  course: "Mathematics" },
  { id:  8, name: "Karl",    course: "Computer Science" },
  { id:  9, name: "Hans",    course: "Mathematics" },
  { id: 10, name: "Barbara", course: "Computer Science" }
];

app.get("/", (req, res) => {
  res.send("Hello, World from Express!");
});

app.get("/students", (req, res) => {
  res.json(students);
});

// **NEW** GET one Student per ID
app.get("/students/:id", (req, res) => {
  const id = parseInt(req.params.id);
  const student = students.find(s => s.id === id);

  if (!student) {
    return res.status(404).json({ error: "Student not found" });
  }

  res.json(student);
});

app.listen(port, () => {
  console.log(`Server running at http://localhost:${port}`);
});