class Person {
  constructor(name) {
    this._name = name; // das Unterstrich-Attribut ist eine Konvention für "intern"
  }

  // Getter: wird aufgerufen, wenn man person.name schreibt
  get name() {
    return this._name;
  }

  // Setter: wird aufgerufen, wenn man person.name = "..." schreibt
  set name(newName) {
    if (newName.length <= 2) {
      console.log("Name ist zu kurz!");
    } else {
      this._name = newName;
    }
  }
}

const person = new Person("Anna");

console.log(person.name);  // → Anna   (ruft Getter auf)
person.name = "Li";        // → Name ist zu kurz!
person.name = "Maria";     // Setter erlaubt Änderung
console.log(person.name);  // → Maria