package at.spengergasse.urlaub.views.urlaube;

import at.spengergasse.urlaub.domain.Urlaub;
import at.spengergasse.urlaub.service.UrlaubService;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.Menu;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.lineawesome.LineAwesomeIconUrl;

@PageTitle("Urlaube")
@Route("urlaube")
@Menu(order = 2, icon = LineAwesomeIconUrl.UMBRELLA_BEACH_SOLID)
public class UrlaubView extends VerticalLayout {
    private final Grid<Urlaub> grid = new Grid<>(Urlaub.class, true);
    private final UrlaubService urlaubService;

    public UrlaubView(@Autowired UrlaubService urlaubService) {
        this.urlaubService = urlaubService;
        init();
    }

    private void init() {
        setSizeFull();
        grid.setSizeFull();
        add(grid);
        reload();
    }

    private void reload() {
        grid.setItems(urlaubService.findAll());
    }
};
