import org.junit.Test;

import static org.junit.jupiter.api.Assertions.*;

public class StudentTest {
    @Test
    public void testTagStudentStringOK() {
        try {
            Student s = new TagStudent("T;Susi;19;3AHIF;2");
            System.out.println(s);
            assertEquals(1, 1);
        } catch (StudentException e) {
            System.out.println(e.getMessage());
            assertEquals(1, 0);
        }
    }

    @Test
    public void testTagStudentStringKeineZahl() {
        try {
            Student s = new TagStudent("T;Susi;19;3AHIF;AB");
            System.out.println(s);
            assertEquals(1, 0);
        } catch (StudentException e) {
            System.out.println(e.getMessage());
            assertEquals(1, 1);
        }
    }

    @Test
    public void testTagStudentStringKurz() {
        try {
            Student s = new TagStudent("T;Susi;19;3AHIF");
            System.out.println(s);
            assertEquals(1, 0);
        } catch (StudentException e) {
            System.out.println(e.getMessage());
            assertEquals(1, 1);
        }
    }

    @Test
    public void testTagStudentStringNull() {
        try {
            Student s = new TagStudent(null);
            System.out.println(s);
            assertEquals(1, 0);
        } catch (StudentException e) {
            System.out.println(e.getMessage());
            assertEquals(1, 1);
        }
    }


    @Test
    public void testAbendStudentStringOK() {
        try {
            Student s = new AbendStudent("A;Thomas;25;3ACIF;Y");
            System.out.println(s);
            assertEquals(1, 1);
        } catch (StudentException e) {
            System.out.println(e.getMessage());
            assertEquals(1, 0);
        }
    }

    @Test
    public void testAbendStudentStringNULL() {
        try {
            Student s = new AbendStudent(null);
            System.out.println(s);
            assertEquals(1, 0);
        } catch (StudentException e) {
            System.out.println(e.getMessage());
            assertEquals(1, 1);
        }
    }

    @Test
    public void testAbendStudentStringKurz() {
        try {
            Student s = new AbendStudent("A;Thomas;25;3ACIF");
            System.out.println(s);
            assertEquals(1, 0);
        } catch (StudentException e) {
            System.out.println(e.getMessage());
            assertEquals(1, 1);
        }
    }

    @Test
    public void testAbendStudentStringKeineZahl() {
        try {
            Student s = new AbendStudent("A;Thomas;ABC;3ACIF;N");
            System.out.println(s);
            assertEquals(1, 0);
        } catch (StudentException e) {
            System.out.println(e.getMessage());
            assertEquals(1, 1);
        }
    }


    @Test
    public void testTagStudentStringAlter() {
        try {
            Student s = new TagStudent("T;Susi;AB;3AHIF;2");
            System.out.println(s);
            assertEquals(0,1);
        }
        catch (StudentException e) {
            System.out.println(e.getMessage());
            assertEquals("Ungültiges Alter : AB", e.getMessage());
            assertEquals(1,1);
        }
    }

    @Test
    public void testTagStudentString() {
        try {
            Student s = new TagStudent("T;Susi;19;3AHIF;2");
            System.out.println(s);
            assertEquals(1,1);
        }
        catch (StudentException e) {
            System.out.println(e.getMessage());
            assertEquals(1,0);
        }
    }

    @Test
    public void testAbendStudentString() {
        try {
            Student s = new AbendStudent("A;Thomas;25;3ACIF;Y");
            System.out.println(s);
            assertEquals(1,1);
        }
        catch (StudentException e) {
            System.out.println(e.getMessage());
            assertEquals(1,0);
        }
    }

    @Test
    public void testAbendStudentOK() {
        try {
            Student s = new AbendStudent("Susi", 22, "5ABIF", false);
            System.out.println(s);
            assertEquals(1,1);
        }
        catch (StudentException e) {
            System.out.println(e.getMessage());
            assertEquals(1,0);
        }
    }

    @Test
    public void testAbendStudentJung() {
        try {
            Student s = new AbendStudent("Susi", 16, "5ABIF", false);
            System.out.println(s);
            assertEquals(1,0);
        }
        catch (StudentException e) {
            System.out.println(e.getMessage());
            assertEquals(1,1);
        }
    }

    @Test
    public void testAbendStudentAlt() {
        try {
            Student s = new AbendStudent("Susi", 61, "5ABIF", false);
            System.out.println(s);
            assertEquals(1,0);
        }
        catch (StudentException e) {
            System.out.println(e.getMessage());
            assertEquals(1,1);
        }
    }

    /*
    @Test
    public void testTagStudent() {
        Student s = new TagStudent("Werner", 18, "2AHIF", 0);
        System.out.println(s);
        assertEquals(7, s.restSemester());
    }*/
}