import org.junit.jupiter.api.Test;

import static org.junit.Assert.assertEquals;

class SchoolTest {
    @Test
    public void testImportOK() {
        School s;
        s = new School();
        try {
            s.importSchool("daten.txt");
            System.out.println(s);
            assertEquals(5, s.anzahlStudent());
        }
        catch (StudentException e) {
            System.out.println(e.getMessage());
            assertEquals(1,0);
        }
    }

    @Test
    public void testImportNull() {
        School s;
        s = new School();
        try {
            s.importSchool(null);
            System.out.println(s);
            assertEquals(1,0);
        }
        catch (StudentException e) {
            System.out.println(e.getMessage());
            assertEquals(1,1);
        }
    }

    @Test
    public void testImportKeineDatei() {
        School s;
        s = new School();
        try {
            s.importSchool("nofile.txt");
            System.out.println(s);
            assertEquals(1,0);
        }
        catch (StudentException e) {
            System.out.println(e.getMessage());
            assertEquals(1,1);
        }
    }

    @Test
    public void testImportUngultig() {
        School s;
        s = new School();
        try {
            s.importSchool("daten_err1.txt");
            System.out.println(s);
            assertEquals(1,0);
        }
        catch (StudentException e) {
            System.out.println(e.getMessage());
            System.out.println(s);
            assertEquals(1,1);
        }
    }
}