public class TagStudent extends Student {
    private int anzahlFerialpraxis;

    public TagStudent(String name, int alter, String klasse, int anzahlFerialpraxis) throws StudentException {
        super(name, alter, klasse);
        setAnzahlFerialpraxis (anzahlFerialpraxis);
    }

    //T;Susi;19;3AHIF;2
    public TagStudent(String zeile) throws StudentException {
        super(zeile);

        if (zeile == null)
            throw new StudentException("Fehler: ungültige Datenzeile!");
        String[] daten;
        daten = zeile.split(";");

        if (daten.length != 5)
            throw new StudentException("Fehler: ungültige Datenzeile!");
        try {
            setAnzahlFerialpraxis(Integer.parseInt(daten[4]));
        } catch (NumberFormatException e) {
            throw new StudentException("Fehler: Anzahl muss eine Zahl sein!");
        }
    }


    public int getAnzahlFerialpraxis() {
        return anzahlFerialpraxis;
    }

    public void setAnzahlFerialpraxis(int anzahlFerialpraxis) {
        this.anzahlFerialpraxis = anzahlFerialpraxis;
    }

    @Override
    public void setAlter(int alter) throws StudentException {
        if (alter < 13)
            throw new StudentException("Fehler: ungültiges Alter! Muss mind. 13 Jahre sein!");
        if (alter > 22)
            throw new StudentException("Fehler: ungültiges Alter! Darf max. 22 Jahre sein!");
        this.alter = alter;
    }

    public int aktuellesSemester() {
        // 3AHIF  2AHWIT
        String klasse = super.getKlasse();
        int jahr;

        jahr = Integer.parseInt(klasse.substring(0, 1));
        return jahr*2-1;
    }

    public int dauerStudiumSemester() {
        return 10;
    }

    @Override
    public String toString() {
        return super.toString() + " " + anzahlFerialpraxis + " Anzahl der Ferialpraktika";
    }
}
