public abstract class Student {
    private   String  name;
    protected int     alter;
    private   String  klasse;

    public Student(String name, int alter, String klasse) throws StudentException {
        setName(name);
        setAlter(alter);
        setKlasse(klasse);
    }

    //A;Thomas;25;3ACIF;Y
    public Student(String zeile) throws StudentException {
        String[] daten;

        if (zeile == null)
            throw new StudentException("Fehler: ungültige Datenzeile!");

        daten = zeile.split(";");
        if (daten.length < 4)
            throw new StudentException("Fehler: ungültige Datenzeile!");


        try {
            setName(daten[1]);
            setAlter(Integer.parseInt(daten[2]));
            setKlasse(daten[3]);
        }
        catch (NumberFormatException e) {
            throw new StudentException("Das Alter muss eine Zahl sein!");
        }
    }

    public String getKlasse() {
        return klasse;
    }

    public void setKlasse(String klasse) {
        this.klasse = klasse;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getAlter() {
        return alter;
    }

    public abstract void setAlter(int alter) throws StudentException;
    public abstract int aktuellesSemester();
    protected abstract int dauerStudiumSemester();

    public int restSemester() {
        return dauerStudiumSemester() - aktuellesSemester();
    }

    @Override
    public String toString() {
        return name + "   " + alter + " Jahre " + klasse;
    }
}
