import java.io.*;
import java.util.ArrayList;
import java.util.Iterator;

public class School {
    private ArrayList<Student> students;

    public School() {
        students = new ArrayList<>(100);
    }

    public void aufnehmen(Student s) throws StudentException {
        if (s == null)
            throw new StudentException("Fehler: kein Student!");
        if (students.contains(s))
            throw new StudentException("Fehler: Student schon angemeldet!");

        students.add(s);
    }

    public void importSchool(String filename) throws StudentException {
        FileReader fr = null;
        String zeile;

        if (filename == null)
            throw new StudentException("Fehler: keine Datei!");

        try {
            fr = new FileReader(filename);
            BufferedReader br = new BufferedReader(fr);
            zeile = br.readLine();
            while (zeile != null) {
                //System.out.println(zeile);
                if (zeile.startsWith("A"))
                    aufnehmen(new AbendStudent(zeile));
                else
                    if (zeile.startsWith("T"))
                        aufnehmen(new TagStudent(zeile));
                zeile = br.readLine();
            }
            br.close();
            fr.close();
        }
        catch (FileNotFoundException e) {
            throw new StudentException("Fehler: kann die Datei " + filename + " nicht finden!");
        } catch (IOException e) {
            throw new StudentException("Fehler: kann die Datei " + filename + " nicht lesen!");
        }
    }

    public int anzahlStudent() {
        return students.size();
    }

    public Student maxAlter() {
        int max = -9999;
        Student maxStudent = null;

        for (Student s : students) {
            if (s.getAlter() > max) {
                max = s.getAlter();
                maxStudent = s;
            }
        }
        return maxStudent;
    }

    public void loschenName(String name) {
        Iterator<Student> it;
        Student s;

        it = students.iterator();
        while (it.hasNext()) {
            s = it.next();
            if (s.getName().equals(name))
                it.remove();
        }
    }

    public String toString() {
        String erg = "";
        for (Student s : students) {
            erg += s.toString() + "\n";
        }
        return erg;
    }
}
