import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

public class CTestLoop1 {
    @Test
    public void testNull() {
        Handler markt;
        markt = new Handler();
        try {
            Produkt a, b, c, d, e, f, g, h, i;
            a = new Produkt("Lenovo", 999.9);
            b = new Produkt("HP",     849.5);
            c = new Produkt("Dell",   1099.0);
            d = new Produkt("Dell",   1999.9);
            e = new Produkt("Asus",   799.0);
            f = new Produkt("Acer",   699.5);
            g = new Produkt("MSI",    1299.0);
            markt.aufnehmen(a);
            markt.aufnehmen(b);
            markt.aufnehmen(c);
            markt.aufnehmen(d);
            markt.aufnehmen(e);
            markt.aufnehmen(f);
            markt.aufnehmen(g);
            assertNull(markt.billigstesProdukt(null));
        }
        catch (Exception e) {
            assertEquals(1, 1);
        }
    }

    @Test
    public void testNotFound() {
        Handler markt;
        markt = new Handler();
        try {
            Produkt a, b, c, d, e, f, g, h, i;
            a = new Produkt("Lenovo", 999.9);
            b = new Produkt("HP",     849.5);
            c = new Produkt("Dell",   1099.0);
            d = new Produkt("Dell",   1999.9);
            e = new Produkt("Asus",   799.0);
            f = new Produkt("Acer",   699.5);
            g = new Produkt("MSI",    1299.0);
            markt.aufnehmen(a);
            markt.aufnehmen(b);
            markt.aufnehmen(c);
            markt.aufnehmen(d);
            markt.aufnehmen(e);
            markt.aufnehmen(f);
            markt.aufnehmen(g);
            assertNull(markt.billigstesProdukt("Apple"));
        }
        catch (Exception e) {
            assertEquals(1, 0);
        }
    }

    @Test
    public void testFound1() {
        Handler markt;
        markt = new Handler();
        try {
            Produkt a, b, c, d, e, f, g, h, i;
            a = new Produkt("Lenovo", 999.9);
            b = new Produkt("HP",     849.5);
            c = new Produkt("Dell",   1099.0);
            d = new Produkt("Dell",   1999.9);
            e = new Produkt("Asus",   799.0);
            f = new Produkt("Acer",   699.5);
            g = new Produkt("MSI",    1299.0);
            markt.aufnehmen(a);
            markt.aufnehmen(b);
            markt.aufnehmen(c);
            markt.aufnehmen(d);
            markt.aufnehmen(e);
            markt.aufnehmen(f);
            markt.aufnehmen(g);
            assertEquals(b, markt.billigstesProdukt("HP"));
        }
        catch (Exception e) {
            assertEquals(1, 0);
        }
    }

    @Test
    public void testFound3() {
        Handler markt;
        markt = new Handler();
        try {
            Produkt a, b, c, d, e, f, g, h, i;
            a = new Produkt("Lenovo", 999.9);
            b = new Produkt("HP",     849.5);
            c = new Produkt("Dell",   1099.0);
            d = new Produkt("Dell",   999.9);
            e = new Produkt("Asus",   799.0);
            f = new Produkt("Acer",   699.5);
            g = new Produkt("Dell",   1299.0);
            markt.aufnehmen(a);
            markt.aufnehmen(b);
            markt.aufnehmen(c);
            markt.aufnehmen(d);
            markt.aufnehmen(e);
            markt.aufnehmen(f);
            markt.aufnehmen(g);
            assertEquals(d, markt.billigstesProdukt("Dell"));
        }
        catch (Exception e) {
            assertEquals(1, 0);
        }
    }

    @Test
    public void testFound2() {
        Handler markt;
        markt = new Handler();
        try {
            Produkt a, b, c, d, e, f, g, h, i;
            a = new Produkt("Lenovo", 999.9);
            b = new Produkt("HP",     849.5);
            c = new Produkt("Dell",   1099.0);
            d = new Produkt("Dell",   999.9);
            e = new Produkt("Asus",   799.0);
            f = new Produkt("Acer",   699.5);
            g = new Produkt("Lenovo", 1299.0);
            markt.aufnehmen(a);
            markt.aufnehmen(b);
            markt.aufnehmen(c);
            markt.aufnehmen(d);
            markt.aufnehmen(e);
            markt.aufnehmen(f);
            markt.aufnehmen(g);
            assertEquals(a, markt.billigstesProdukt("Lenovo"));
        }
        catch (Exception e) {
            assertEquals(1, 0);
        }
    }
}