

import static org.junit.jupiter.api.Assertions.*;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHaus
{
    @Test
    public void testTauschenNull()
    {
        Haus wn = new Haus("Wiener Neustadt");
        Haus w  = new Haus("Wien");
        Fenster a = new Fenster("Alu",        499, true);
        Fenster b = new Fenster("Holz",       599, true);
        Fenster c = new Fenster("Holz",       399, false);
        Fenster d = new Fenster("Kunststoff", 199, false);
        assertEquals(0, wn.anzahlFenster());
        assertEquals(0, w.anzahlFenster());
        assertEquals(null, a.getHaus());
        a.tauschen(null);
        //Fehler
        assertEquals(0, wn.anzahlFenster());
        assertEquals(0, w.anzahlFenster());
        assertEquals(null, a.getHaus());
    }

    @Test
    public void testTauschenThisHausNull()
    {
        Haus wn = new Haus("Wiener Neustadt");
        Haus w  = new Haus("Wien");
        Fenster a = new Fenster("Alu",        499, true);
        Fenster b = new Fenster("Holz",       599, true);
        Fenster c = new Fenster("Holz",       399, false);
        Fenster d = new Fenster("Kunststoff", 199, false);
        wn.einbauen(a);
        assertEquals(1, wn.anzahlFenster());
        assertEquals(0, w.anzahlFenster());
        assertEquals(wn, a.getHaus());
        assertEquals(null, b.getHaus());
        b.tauschen(a);
        //Fehler
        assertEquals(1, wn.anzahlFenster());
        assertEquals(0, w.anzahlFenster());
        assertEquals(wn, a.getHaus());
        assertEquals(null, b.getHaus());
    }

    @Test
    public void testTauschenAnderesHausNull()
    {
        Haus wn = new Haus("Wiener Neustadt");
        Haus w  = new Haus("Wien");
        Fenster a = new Fenster("Alu",        499, true);
        Fenster b = new Fenster("Holz",       599, true);
        Fenster c = new Fenster("Holz",       399, false);
        Fenster d = new Fenster("Kunststoff", 199, false);
        wn.einbauen(a);
        assertEquals(1, wn.anzahlFenster());
        assertEquals(0, w.anzahlFenster());
        assertEquals(wn, a.getHaus());
        assertEquals(null, b.getHaus());
        a.tauschen(b);
        //Fehler
        assertEquals(1, wn.anzahlFenster());
        assertEquals(0, w.anzahlFenster());
        assertEquals(wn, a.getHaus());
        assertEquals(null, b.getHaus());
    }
    
    @Test
    public void testTauschenGleichesHaus()
    {
        Haus wn = new Haus("Wiener Neustadt");
        Haus w  = new Haus("Wien");
        Fenster a = new Fenster("Alu",        499, true);
        Fenster b = new Fenster("Holz",       599, true);
        Fenster c = new Fenster("Holz",       399, false);
        Fenster d = new Fenster("Kunststoff", 199, false);
        wn.einbauen(a);
        wn.einbauen(b);
        wn.einbauen(c);
        w.einbauen(d);
        assertEquals(3, wn.anzahlFenster());
        assertEquals(1, w.anzahlFenster());
        assertEquals(wn, a.getHaus());
        assertEquals(wn, b.getHaus());
        assertEquals(wn, c.getHaus());
        assertEquals(w, d.getHaus());
        a.tauschen(c);
        //Fehler
        assertEquals(3, wn.anzahlFenster());
        assertEquals(1, w.anzahlFenster());
        assertEquals(wn, a.getHaus());
        assertEquals(wn, b.getHaus());
        assertEquals(wn, c.getHaus());
        assertEquals(w, d.getHaus());
    }

    @Test
    public void testTauschenOK()
    {
        Haus wn = new Haus("Wiener Neustadt");
        Haus w  = new Haus("Wien");
        Fenster a = new Fenster("Alu",        499, true);
        Fenster b = new Fenster("Holz",       599, true);
        Fenster c = new Fenster("Holz",       399, false);
        Fenster d = new Fenster("Kunststoff", 199, false);
        wn.einbauen(a);
        wn.einbauen(b);
        wn.einbauen(c);
        w.einbauen(d);
        assertEquals(3, wn.anzahlFenster());
        assertEquals(1, w.anzahlFenster());
        assertEquals(wn, a.getHaus());
        assertEquals(wn, b.getHaus());
        assertEquals(wn, c.getHaus());
        assertEquals(w, d.getHaus());
        b.tauschen(d);
        assertEquals(3, wn.anzahlFenster());
        assertEquals(1, w.anzahlFenster());
        assertEquals(wn, a.getHaus());
        assertEquals(w, b.getHaus());
        assertEquals(wn, c.getHaus());
        assertEquals(wn, d.getHaus());
    }

    @Test
    public void testTauschenFrage()
    {
        Haus wn = new Haus("Wiener Neustadt");
        Haus w  = new Haus("Wien");
        Fenster a = new Fenster("Alu",        499, true);
        Fenster b = new Fenster("Holz",       599, true);
        Fenster c = new Fenster("Holz",       399, false);
        Fenster d = new Fenster("Kunststoff", 199, false);
        wn.einbauen(a);
        wn.einbauen(b);
        wn.einbauen(c);
        w.einbauen(d);
        assertEquals(3, wn.anzahlFenster());
        assertEquals(1, w.anzahlFenster());
        assertEquals(wn, a.getHaus());
        assertEquals(wn, b.getHaus());
        assertEquals(wn, c.getHaus());
        assertEquals(w, d.getHaus());
        b.tauschen(b);
        //Fehler
        assertEquals(3, wn.anzahlFenster());
        assertEquals(1, w.anzahlFenster());
        assertEquals(wn, a.getHaus());
        assertEquals(wn, b.getHaus());
        assertEquals(wn, c.getHaus());
        assertEquals(w, d.getHaus());
    }

    
    @Test
    public void testAusbauenNull()
    {
        Haus wn = new Haus("Wiener Neustadt");
        wn.ausbauen(null);
        assertEquals(0, wn.anzahlFenster());
    }
    
    @Test
    public void testAusbauenAndrenHaus()
    {
        Haus wn = new Haus("Wiener Neustadt");
        Haus w = new Haus("Wien");
        Fenster a = new Fenster("Alu",        499, true);
        Fenster b = new Fenster("Holz",       599, true);
        Fenster c = new Fenster("Holz",       399, false);
        Fenster d = new Fenster("Kunststoff", 199, false);
        wn.einbauen(a);
        wn.einbauen(b);
        wn.einbauen(c);
        w.einbauen(d);
        assertEquals(3, wn.anzahlFenster());
        assertEquals(1, w.anzahlFenster());
        assertEquals(wn, a.getHaus());
        assertEquals(wn, b.getHaus());
        assertEquals(wn, c.getHaus());
        assertEquals(w, d.getHaus());
        w.ausbauen(a);
        //Fehler
        assertEquals(3, wn.anzahlFenster());
        assertEquals(1, w.anzahlFenster());
        assertEquals(wn, a.getHaus());
        assertEquals(wn, b.getHaus());
        assertEquals(wn, c.getHaus());
        assertEquals(w, d.getHaus());        
    }

    @Test
    public void testAusbauenPos0()
    {
        Haus wn = new Haus("Wiener Neustadt");
        Fenster a = new Fenster("Alu",        499, true);
        Fenster b = new Fenster("Holz",       599, true);
        Fenster c = new Fenster("Holz",       399, false);
        wn.einbauen(a);
        wn.einbauen(b);
        wn.einbauen(c);
        assertEquals(3, wn.anzahlFenster());
        assertEquals(wn, a.getHaus());
        assertEquals(wn, b.getHaus());
        assertEquals(wn, c.getHaus());
        wn.ausbauen(a);
        assertEquals(2, wn.anzahlFenster());
        assertEquals(null, a.getHaus());
        assertEquals(wn, b.getHaus());
        assertEquals(wn, c.getHaus());
    }

    @Test
    public void testAusbauenPos1()
    {
        Haus wn = new Haus("Wiener Neustadt");
        Fenster a = new Fenster("Alu",        499, true);
        Fenster b = new Fenster("Holz",       599, true);
        Fenster c = new Fenster("Holz",       399, false);
        wn.einbauen(a);
        wn.einbauen(b);
        wn.einbauen(c);
        assertEquals(3, wn.anzahlFenster());
        assertEquals(wn, a.getHaus());
        assertEquals(wn, b.getHaus());
        assertEquals(wn, c.getHaus());
        wn.ausbauen(b);
        assertEquals(2, wn.anzahlFenster());
        assertEquals(wn, a.getHaus());
        assertEquals(null, b.getHaus());
        assertEquals(wn, c.getHaus());
    }
    
    @Test
    public void testAusbauenPos2()
    {
        Haus wn = new Haus("Wiener Neustadt");
        Fenster a = new Fenster("Alu",        499, true);
        Fenster b = new Fenster("Holz",       599, true);
        Fenster c = new Fenster("Holz",       399, false);
        wn.einbauen(a);
        wn.einbauen(b);
        wn.einbauen(c);
        assertEquals(3, wn.anzahlFenster());
        assertEquals(wn, a.getHaus());
        assertEquals(wn, b.getHaus());
        assertEquals(wn, c.getHaus());
        wn.ausbauen(c);
        assertEquals(2, wn.anzahlFenster());
        assertEquals(wn, a.getHaus());
        assertEquals(wn, b.getHaus());
        assertEquals(null, c.getHaus());
    }
    
    @Test
    public void testEinbauenNull()
    {
        Haus wn = new Haus("Wiener Neustadt");
        wn.einbauen(null);
        assertEquals(0, wn.anzahlFenster());
        //Fehler
    }

    @Test
    public void testEinbauenA()
    {
        Haus wn = new Haus("Wiener Neustadt");
        Fenster a = new Fenster("Alu", 399, true);
        
        wn.einbauen(a);
        assertEquals(1, wn.anzahlFenster());
        assertEquals(wn, a.getHaus());
    }
    
    @Test
    public void testEinbauen2xA()
    {
        Haus wn = new Haus("Wiener Neustadt");
        Fenster a = new Fenster("Alu", 399, true);
        
        wn.einbauen(a);
        wn.einbauen(a);
        assertEquals(1, wn.anzahlFenster());
        assertEquals(wn, a.getHaus());
    }
    
    @Test
    public void testEinbauenWienerNeustadtWien()
    {
        Haus wn = new Haus("Wiener Neustadt");
        Haus w = new Haus("Wien");
        Fenster a = new Fenster("Alu", 399, true);
        
        wn.einbauen(a);
        w.einbauen(a);
        //Fehler
        assertEquals(1, wn.anzahlFenster());
        assertEquals(wn, a.getHaus());
        assertEquals(0, w.anzahlFenster());
    }

    
    @Test
    public void testEinbauen()
    {
        Fenster a, b, c, d;
        Haus haus;
        
        a = new Fenster("Alu",        499, true);
        b = new Fenster("Holz",       599, true);
        c = new Fenster("Holz",       399, false);
        d = new Fenster("Kunststoff", 199, false);
        haus = new Haus("Wiener Neustadt");
        haus.printHaus();
        System.out.println("====================");
        haus.einbauen(a);
        haus.printHaus();
        System.out.println("====================");
        haus.einbauen(b);
        haus.printHaus();
        System.out.println("====================");
        haus.einbauen(c);
        haus.printHaus();
        System.out.println("====================");
        haus.einbauen(d);
        // Fehler
        haus.printHaus();
        System.out.println("====================");
    }
    
    @Test
    public void testMaxPreis0()
    {
        Fenster a, b, c;
        Haus haus;
        
        a = new Fenster("Alu",        669, true);
        b = new Fenster("Holz",       599, true);
        c = new Fenster("Holz",       399, false);
        haus = new Haus("Wiener Neustadt");
        assertEquals(-9999, haus.teuerstesFenster());
        haus.einbauen(a);
        assertEquals(669, haus.teuerstesFenster());
        haus.einbauen(b);
        assertEquals(669, haus.teuerstesFenster());
        haus.einbauen(c);
        assertEquals(669, haus.teuerstesFenster());
        haus.printHaus();
    }
    
    @Test
    public void testMaxPreis1()
    {
        Fenster a, b, c;
        Haus haus;
        
        a = new Fenster("Alu",        499, true);
        b = new Fenster("Holz",       599, true);
        c = new Fenster("Holz",       399, false);
        haus = new Haus("Wiener Neustadt");
        assertEquals(-9999, haus.teuerstesFenster());
        haus.einbauen(a);
        assertEquals(499, haus.teuerstesFenster());
        haus.einbauen(b);
        assertEquals(599, haus.teuerstesFenster());
        haus.einbauen(c);
        assertEquals(599, haus.teuerstesFenster());
        haus.printHaus();
    }

    @Test
    public void testMaxPreis2()
    {
        Fenster a, b, c;
        Haus haus;
        
        a = new Fenster("Alu",        499, true);
        b = new Fenster("Holz",       599, true);
        c = new Fenster("Holz",       649, false);
        haus = new Haus("Wiener Neustadt");
        assertEquals(-9999, haus.teuerstesFenster());
        haus.einbauen(a);
        assertEquals(499, haus.teuerstesFenster());
        haus.einbauen(b);
        assertEquals(599, haus.teuerstesFenster());
        haus.einbauen(c);
        assertEquals(649, haus.teuerstesFenster());
        haus.printHaus();
    }

    @Test
    public void testMinPreisOhne()
    {
        Haus haus;
        
        haus = new Haus("Wiener Neustadt");
        assertEquals(null, haus.billigFenster());
    }
    
    @Test
    public void testMinPreis0()
    {
        Fenster a, b, c;
        Haus haus;
        
        a = new Fenster("Alu",        499, true);
        b = new Fenster("Holz",       599, true);
        c = new Fenster("Holz",       649, false);
        haus = new Haus("Wiener Neustadt");
        assertEquals(null, haus.billigFenster());
        haus.einbauen(a);
        assertEquals(a, haus.billigFenster());
        haus.einbauen(b);
        assertEquals(a, haus.billigFenster());
        haus.einbauen(c);
        assertEquals(a, haus.billigFenster());
    }
    
    @Test
    public void testMinPreis1()
    {
        Fenster a, b, c;
        Haus haus;
        
        a = new Fenster("Alu",        499, true);
        b = new Fenster("Holz",       399, true);
        c = new Fenster("Holz",       649, false);
        haus = new Haus("Wiener Neustadt");
        assertEquals(null, haus.billigFenster());
        haus.einbauen(a);
        assertEquals(a, haus.billigFenster());
        haus.einbauen(b);
        assertEquals(b, haus.billigFenster());
        haus.einbauen(c);
        assertEquals(b, haus.billigFenster());
    }    

    @Test
    public void testMinPreis2()
    {
        Fenster a, b, c;
        Haus haus;
        
        a = new Fenster("Alu",        499, true);
        b = new Fenster("Holz",       599, true);
        c = new Fenster("Holz",       349, false);
        haus = new Haus("Wiener Neustadt");
        assertEquals(null, haus.billigFenster());
        haus.einbauen(a);
        assertEquals(a, haus.billigFenster());
        haus.einbauen(b);
        assertEquals(a, haus.billigFenster());
        haus.einbauen(c);
        assertEquals(c, haus.billigFenster());
    }    
}

