public class Haus
{
    private String  ort;
    private Fenster fenster0;
    private Fenster fenster1;
    private Fenster fenster2;
    
    public Haus(String ort)
    {
        setOrt(ort);
    }
    
    public String getOrt()
    {
        return ort;
    }

    public void setOrt(String ort)
    {
        this.ort = ort;
    }
    
    public int anzahlFenster()
    {
        int anz=0;
        
        if (fenster0 != null)
        {
            anz++;
        }
        if (fenster1 != null)
        {
            anz++;
        }
        if (fenster2 != null)
        {
            anz++;
        }
        return anz;
    }
    
    public void einbauen(Fenster welches)
    {
        if (welches != null)
        {
            if (welches.getHaus() == null)
            {
                if (fenster0 == null)
                {        
                    fenster0 = welches;
                    welches.setHaus(this);
                }
                else
                {
                    if (fenster1 == null)
                    {
                        fenster1 = welches;
                        welches.setHaus(this);
                    }
                    else
                    {
                        if (fenster2 == null)
                        {
                            fenster2 = welches;
                            welches.setHaus(this);
                        }
                        else
                        {
                            System.out.println("Fehler: alle Fenster eingebaut!");
                        }
                    }
                }
            }
            else
            {
                System.out.println("Fehler: Fenster bereits eingebaut!");
            }
        }
        else
        {
            System.out.println("Fehler: kein Fenster!");
        }
    }
    
    public void ausbauen(Fenster welches)
    {
        if (welches != null)
        {
            if (welches.getHaus() == this)
            {
                if (welches == fenster0)
                {
                    fenster0 = null;
                    welches.setHaus(null);
                }
                else
                {
                    if (welches == fenster1)
                    {
                        fenster1 = null;
                        welches.setHaus(null);
                    }
                    else
                    {
                        if (welches == fenster2)
                        {
                            fenster2 = null;
                            welches.setHaus(null);
                        }
                        else
                        {
                            System.out.println("Interner Fehler!");
                        }
                    }
                }
            }
            else
            {
                System.out.println("Fehler: nicht in diesem Haus verbaut!");
            }
        }
        else
        {
            System.out.println("Fehler: kein Fenster!");
        }
    }
    
    public void printHaus()
    {
        System.out.println(ort);
        if (fenster0 != null)
        {
            fenster0.printFenster();
        }
        if (fenster1 != null)
        {
            fenster1.printFenster();
        }
        if (fenster2 != null)
        {
            fenster2.printFenster();
        }
    }
    
    public Fenster billigFenster()
    {
        int minPreis;
        Fenster minFenster;
        
        minPreis = 9999;
        minFenster = null;
        if (fenster0 != null)
        {
            if (fenster0.getPreis() < minPreis)
            {
                minPreis = fenster0.getPreis();
                minFenster = fenster0;
            }
        }
        if (fenster1 != null)
        {
            if (fenster1.getPreis() < minPreis)
            {
                minPreis = fenster1.getPreis();
                minFenster = fenster1;
            }
        }
        if (fenster2 != null)
        {
            if (fenster2.getPreis() < minPreis)
            {
                minPreis = fenster2.getPreis();
                minFenster = fenster2;
            }
        }
        return minFenster;
    }
    
    public int teuerstesFenster()
    {
        int maxPreis;
        
        maxPreis = -9999;
        if (fenster0 != null)
        {
            if (fenster0.getPreis() > maxPreis)
            {
                maxPreis = fenster0.getPreis();
            }
        }
        if (fenster1 != null)
        {
            if (fenster1.getPreis() > maxPreis)
            {
                maxPreis = fenster1.getPreis();
            }
        }
        if (fenster2 != null)
        {
            if (fenster2.getPreis() > maxPreis)
            {
                maxPreis = fenster2.getPreis();
            }
        }
        return maxPreis;
    }
}



















