public class Fenster
{
    private String  material;       // Alu Holz Kunststoff
    private int     preis;          // Der Preis des Fensters inkl. Steuer in Euro
    private boolean kippbar;        // Kann das Fenster gekippt werden
    private Haus    haus;           // backreference
    
    public Fenster(String material, int preis, boolean kippbar)
    {
        setMaterial(material);
        setPreis(preis);
        setKippbar(kippbar);
    }
    
    public Fenster(int preis)
    {
        setMaterial("Alu");
        setPreis(preis);
        setKippbar(true);
    }
    
    public Fenster(String material, int preis)
    {
        setMaterial(material);
        setPreis(preis);
        setKippbar(true);  
    }
    
    public Fenster()
    {
        setMaterial("Alu");
        setPreis(499);
        setKippbar(true);
    }
    
    public String getMaterial()
    {
        return material;
    }
    
    public int getPreis()
    {
        return preis;
    }
    
    public boolean getKippbar()
    {
        return kippbar;
    }
    
    public Haus getHaus()
    {
        return haus;
    }
    
    public void setMaterial(String material)
    {
        // Die Eigenschaft material wird mit dem Wert des Parameters neuMaterial überschrieben
        this.material = material;
    }
    
    public void setPreis(int preis)
    {
        if ((preis >= 199) && (preis <= 899))
        {
            this.preis = preis;
        }
        else
        {
            System.out.println("Fehler: ungültiger Preis " + preis + "!");
            this.preis = 499;
        }
    }
    
    public void setKippbar(boolean kippbar)
    {
        this.kippbar = kippbar;
    }
    
    public void setHaus(Haus haus)
    {
        this.haus = haus;
    }

    public void testen()
    {
        //System.out.println(material.charAt(0));
        //System.out.println(material.charAt(2));
        System.out.println(material.indexOf(" "));
    }
    
    //             012345
    // material = "Alu 35"
    public String getRohstoff()
    {
        int pos;
        
        pos = material.indexOf(" ");        // 3
        return material.substring(0, pos);  // 0 .. 3 => "Alu"
    }
    
    public void tauschen(Fenster anderes)
    {
        // anderes <-> this
        Haus hausThis;
        Haus anderesHaus;
        
        if (anderes != null)
        {
            if ((this.getHaus() != null) && (anderes.getHaus() != null))
            {
                if (this.getHaus() != anderes.getHaus())
                {
                    hausThis = haus;
                    anderesHaus = anderes.getHaus();
                    hausThis.ausbauen(this);
                    anderesHaus.ausbauen(anderes);
                    hausThis.einbauen(anderes);
                    anderesHaus.einbauen(this);
                }
                else
                {
                    System.out.println("Fehler: Fenster im gleichen Haus verbaut!");
                }
            }
            else
            {
                System.out.println("Fehler: nicht in einem Haus verbaut!");
            }
        }
        else
        {
            System.out.println("Fehler: kein Fenster!");
        }
    }
    
    /*
    material Fenster: preis EUR - kippbar
    Alu Fenster: 399 EUR - KIPPBAR
    Holz Fenster: 459 EUR - nicht KIPPBAR
    */
    public void printFenster()
    {
        if (kippbar == true)
        {
            System.out.println(material + " Fenster: " + preis + " EUR - " + "KIPPBAR");
        }
        else
        { 
            System.out.println(material + " Fenster: " + preis + " EUR - " + "nicht KIPPBAR");
        }
    }
}



















