import java.io.Serializable;
import java.util.Comparator;

public abstract class Zug implements Serializable, Comparable<Zug>
{
    //zugNr
    private   static  int     lastZugNr = 100;
    private   int     zugNr;

    private   String  bahnhof;
    protected double  km;
    private   boolean zulassung;
    protected int     anzahlWagon;

    public Zug(String zeile) throws ZugException
    {
        //_:Wien:2000:Y:5
        String[] teile;

        try
        {
            setZugNr();
            teile = zeile.split(":");
            setBahnhof(teile[1]);
            setKm(Double.parseDouble(teile[2]));
            setZulassung(teile[3].toUpperCase().equals("Y"));
            setAnzahlWagon(Integer.parseInt(teile[4]));
        }
        catch (NumberFormatException e)
        {
            throw new ZugException("Fehler: keine Zahl als KM bzw. bei der Anzahl angegeben!");
        }
        catch (ArrayIndexOutOfBoundsException e)
        {
            throw new ZugException("Fehler: falsche Datenzeile!");
        }
    }

    public Zug(String bahnhof, double km, boolean zulassung, int anzahlWagon) throws ZugException
    {
        setZugNr();
        setKm(km);
        setBahnhof(bahnhof);
        setZulassung(zulassung);
        setAnzahlWagon(anzahlWagon);
    }

    public int getAnzahlWagon()
    {
        return anzahlWagon;
    }

    public abstract void setAnzahlWagon(int anzahlWagon) throws ZugException;

    public boolean isZulassung()
    {
        return zulassung;
    }

    public void setZulassung(boolean zulassung)
    {
        this.zulassung = zulassung;
    }
    
    public String getBahnhof()
    {
        return bahnhof;
    }

    public void setBahnhof(String bahnhof)
    {
        this.bahnhof = bahnhof;
    }

    public double getKm()
    {
        return km;
    }

    public int getZugNr()
    {
        return zugNr;
    }

    public void setZugNr()
    {
        lastZugNr++;
        this.zugNr = lastZugNr;
    }

    public void setKm(double km) throws ZugException
    {
        if (km < 0)
            throw new ZugException("Fehler: km muss mind. 0 sein!");
        if (km > 100000)
            throw new ZugException("Fehler: km darf max. 100000 sein!");

        this.km = km;
    }

    @Override
    public String toString()
    {
        if (zulassung)
            return zugNr + ": " + bahnhof + " " + km + " km - Zulassung OK - " + anzahlWagon + " Wagon";
        else
            return zugNr + ": " + bahnhof + " " + km + " km - Zulassung FEHLT - " + anzahlWagon + " Wagon";
    }

    public String toStringFile()
    {
        if (zulassung)
            return bahnhof + ":" + km + ":Y:" + anzahlWagon;
        else
            return bahnhof + ":" + km + ":N:" + anzahlWagon;
    }

    /*
    @Override
    public int compareTo(Zug o)
    {
        //this <=> o
        if (this.km > o.km)
            return 17;
        else
        {
            if (this.km == o.km)
                return 0;
            else
                return -775;
        }
    }*/
    @Override
    public int compareTo(Zug o)
    {
        //99      120
        return (int) (this.km - o.km);
    }

}
