import java.io.Serializable;
import java.util.Comparator;

public abstract class Mitarbeiter implements Serializable, Comparable<Mitarbeiter>
{
    private   static int    lastID = 100;
    private   int    mitarbeiterID;
    private   String name;
    protected int    alter;
    private   int    dienstjahre;

    public Mitarbeiter(String zeile) throws MitarbeiterException
    {
        String[] teile;
        teile = zeile.split(";");

        try
        {
            setMitarbeiterID();
            setName(teile[1]);
            setAlter(Integer.parseInt(teile[2]));
            setDienstjahre(Integer.parseInt(teile[3]));
        }
        catch (NumberFormatException e)
        {
            throw new MitarbeiterException("Fehler: keine Zahl - ungültiges Format");
        }
    }

    public Mitarbeiter(String name, int alter, int dienstjahre) throws MitarbeiterException
    {
        setMitarbeiterID();
        setName(name);
        setAlter(alter);
        setDienstjahre(dienstjahre);
    }

    public int getMitarbeiterID()
    {
        return mitarbeiterID;
    }

    public void setMitarbeiterID()
    {
        lastID++;
        this.mitarbeiterID = lastID;
    }

    public String getName()
    {
        return name;
    }

    public void setName(String name)
    {
        this.name = name;
    }

    public int getAlter()
    {
        return alter;
    }

    public abstract void setAlter(int alter) throws MitarbeiterException;

    public abstract double getGeldMonat();

    public abstract double getGeldMonat40Stunden();

    /*
    public String getInitialen() throws MitarbeiterException
    {
        String erg;
        int pos;

        try
        {
            if (name.contains(" "))
            {
                pos = name.indexOf(" ") + 1;
                erg = name.substring(0, 1);
                erg += name.substring(pos, pos + 3);

                return erg;
            }
            else
            {
                throw new MitarbeiterException("Fehler: es gibt keinen Nachnamen!");
            }
        }
        catch (IndexOutOfBoundsException e)
        {
            throw new MitarbeiterException("Fehler: der Nachname ist zu kurz!");
        }
    }
    */

    public String getInitialen() throws MitarbeiterException
    {
        String erg;
        int pos;

        if (name.contains(" ") == false)
            throw new MitarbeiterException("Fehler: es gibt keinen Nachnamen!");

        try
        {
            pos = name.indexOf(" ") + 1;
            erg = name.substring(0, 1);
            erg += name.substring(pos, pos + 3);
            return erg;
        }
        catch (IndexOutOfBoundsException e)
        {
            throw new MitarbeiterException("Fehler: der Nachname ist zu kurz!");
        }
    }

    public int getDienstjahre()
    {
        return dienstjahre;
    }

    public void setDienstjahre(int dienstjahre)
    {
        this.dienstjahre = dienstjahre;
    }

    @Override
    public String toString()
    {
        return mitarbeiterID + ": " + name + " " + alter + " Jahre " + dienstjahre + " Dienstjahre   " + getGeldMonat() + "   ";
    }

    public String toStringFile()
    {
        //R;Susi;49;9;30;57.0
        String erg;

        erg = getName() + ";" + getAlter() + ";" + getDienstjahre();
        return erg;
    }

    @Override
    public int compareTo(Mitarbeiter anderer)
    {
        // this <>= anderer
        //this.dienstjahre <>= anderer.dienstjahre
        /*
        this.dienstjahre - anderer.dienstjahre
                7                    7               = 0
               12                    9               = 3
               12                   20               = -8
        */
        if (this.dienstjahre == anderer.dienstjahre)
        {
            // nach name
            return this.name.compareTo(anderer.name);
        }
        else
        {
            return this.dienstjahre - anderer.dienstjahre;
        }
    }



    public static class SortMitarbeiterName implements Comparator<Mitarbeiter>
    {
        @Override
        public int compare(Mitarbeiter m1, Mitarbeiter m2)
        {
            //m1.getName() m2.getName()
            return m1.getName().compareTo(m2.getName());
        }
    }

    public static class SortMitarbeiterAlter implements Comparator<Mitarbeiter>
    {
        @Override
        public int compare(Mitarbeiter m1, Mitarbeiter m2)
        {
            //m1.getAlter() m2.getAlter()
            return m1.getAlter()-m2.getAlter();
        }
    }

    public static class SortMitarbeiterGetGeldMonat implements Comparator<Mitarbeiter>
    {
        @Override
        public int compare(Mitarbeiter m1, Mitarbeiter m2)
        {
            //m1.getGeldMonat() m2.getGeldMonat()
            return (int)(m1.getGeldMonat() - m2.getGeldMonat());
        }
    }






}
