public abstract class Zug
{
    //zugNr
    private   static  int     lastZugNr = 100;
    private   int     zugNr;

    private   String  bahnhof;
    protected double  km;
    private   boolean zulassung;
    protected int     anzahlWagon;

    public Zug(String bahnhof, double km, boolean zulassung, int anzahlWagon) throws ZugException
    {
        setZugNr();
        setKm(km);
        setBahnhof(bahnhof);
        setZulassung(zulassung);
        setAnzahlWagon(anzahlWagon);
    }

    public int getAnzahlWagon()
    {
        return anzahlWagon;
    }

    public abstract void setAnzahlWagon(int anzahlWagon) throws ZugException;

    public boolean isZulassung()
    {
        return zulassung;
    }

    public void setZulassung(boolean zulassung)
    {
        this.zulassung = zulassung;
    }
    
    public String getBahnhof()
    {
        return bahnhof;
    }

    public void setBahnhof(String bahnhof)
    {
        this.bahnhof = bahnhof;
    }

    public double getKm()
    {
        return km;
    }

    public int getZugNr()
    {
        return zugNr;
    }

    public void setZugNr()
    {
        lastZugNr++;
        this.zugNr = lastZugNr;
    }

    public void setKm(double km) throws ZugException
    {
        if (km < 0)
            throw new ZugException("Fehler: km muss mind. 0 sein!");
        if (km > 100000)
            throw new ZugException("Fehler: km darf max. 100000 sein!");

        this.km = km;
    }

    @Override
    public String toString()
    {
        if (zulassung)
            return zugNr + ": " + bahnhof + " " + km + " km - Zulassung OK - " + anzahlWagon + " Wagon";
        else
            return zugNr + ": " + bahnhof + " " + km + " km - Zulassung FEHLT" + anzahlWagon + " Wagon";
    }
}
