import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

class UnternehmenTest
{
    @Test
    public void testHinzufugenNull()
    {
        Zug a,b,c,d,e,f,g;
        Unternehmen u;

        try
        {
            u = new Unternehmen("SuperSchnell");
            u.hinzufugen(null);
            System.out.println(u);
            assertEquals(1,0);
        }
        catch (ZugException ex)
        {
            System.out.println(ex.getMessage());
            assertEquals(1,1);
        }
    }

    @Test
    public void testHinzufugenDoppelt()
    {
        Zug a,b,c,d,e,f,g;
        Unternehmen u;

        try
        {
            u = new Unternehmen("SuperSchnell");
            a = new GuterZug("Wien", 0, true, 10);
            u.hinzufugen(a);
            u.hinzufugen(a);
            System.out.println(u);
            assertEquals(1,0);
        }
        catch (ZugException ex)
        {
            System.out.println(ex.getMessage());
            assertEquals(1,1);
        }
    }

    @Test
    public void testHinzufugen()
    {
        Zug a,b,c,d,e,f,g;
        Unternehmen u;

        try
        {
            u = new Unternehmen("SuperSchnell");
            a = new GuterZug("Wien", 0, true, 10);
            b = new PersonenZug("Prag", 1000, false, 1, 0);
            c = new GuterZug("Berlin", 1500, true, 5);
            d = new PersonenZug("Wien", 0, false, 3, 400);
            e = new PersonenZug("Baden", 2000, true, 4, 300);
            f = new GuterZug("Wien", 1700, true, 10);
            g = new PersonenZug("Mödling", 15000, true, 2, 800);
            u.hinzufugen(a);
            u.hinzufugen(b);
            u.hinzufugen(c);
            u.hinzufugen(d);
            u.hinzufugen(e);
            u.hinzufugen(f);
            u.hinzufugen(g);
            System.out.println(u);
            assertEquals(1,1);
        }
        catch (ZugException ex)
        {
            System.out.println(ex.getMessage());
            assertEquals(1,0);
        }
    }
}