import java.util.ArrayList;

public class Unternehmen
{
    private String name;
    private ArrayList<Zug> zuge;

    public Unternehmen(String name) throws ZugException
    {
        setName(name);
        zuge = new ArrayList<>();
    }

    public void hinzufugen(Zug z) throws ZugException
    {
        if (z==null)
            throw new ZugException("Fehler: kein Zug!");
        if (zuge.contains(z))
            throw new ZugException("Fehler: Zug schon vorhanden!");

        zuge.add(z);
    }

    public String getName()
    {
        return name;
    }

    public void setName(String name) throws ZugException
    {
        if (name == null)
            throw new ZugException("Fehler: der Name fehlt!");

        this.name = name;
    }

    @Override
    public String toString()
    {
        String erg;

        erg = "Unternehmen: " + name + "\n";
        for (Zug z: zuge)
        {
            erg = erg + z.toString() + "\n";
        }
        return erg;
    }
}
