import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

class ShopTest
{

    @Test
    public void testAddProduct()
    {
        Shop s;
        Drink cola, cola2, fanta;

        s = new Shop();

        try
        {
            s.addProduct(null);
        }
        catch (ProductException e)
        {
            System.out.println(e.getMessage());
            assertEquals("Fehler: kein Produkt!", e.getMessage());
        }

        try
        {
            cola = new Drink("Softdrink", 5, 6, false);
            s.addProduct(cola);
            assertEquals(true, s.containsProduct(cola));
            s.addProduct(cola);
            assertEquals(1,2);
        }
        catch (ProductException e)
        {
            System.out.println(e.getMessage());
            assertEquals("Fehler: das Produkt gibt es bereits!", e.getMessage());
        }

        try
        {
            cola2 = new Drink("Softdrink", 5, 6, false);
            s.addProduct(cola2);
            //assertEquals(true, s.containsProduct(cola));
            assertEquals(true, s.containsProduct(cola2));
        }
        catch (ProductException e)
        {
            System.out.println(e.getMessage());
            assertEquals(1,2);
        }

        try
        {
            fanta = new Drink("Softdrink", 5, 6, false);
            s.addProduct(fanta);
            //assertEquals(true, s.containsProduct(cola));
            assertEquals(true, s.containsProduct(fanta));
        }
        catch (ProductException e)
        {
            System.out.println(e.getMessage());
            assertEquals(1,2);
        }
    }

    @Test
    public void testGetSumStockValue()
    {
        Shop s;
        Drink cola, fanta, bier;

        s = new Shop();
        try
        {
            cola  = new Drink("Softdrink", 4.5, 8, false);
            fanta = new Drink("Softdrink", 3.9, 7, false);
            bier  = new Drink("Light",     6.5, 8, true);

            assertEquals(0, s.getSumStockValue(), 0.1);
            s.addProduct(cola);
            assertEquals(43.2, s.getSumStockValue(), 0.1);
            s.addProduct(fanta);
            assertEquals(75.96, s.getSumStockValue(), 0.1);
            s.addProduct(bier);
            assertEquals(148.76, s.getSumStockValue(), 0.1);
        }
        catch (ProductException e)
        {
            System.out.println(e.getMessage());
            assertEquals(1,2);
        }
    }

    @Test
    public void testDiscount5()
    {
        Shop s;
        Drink cola, fanta, bier;

        s = new Shop();
        try
        {
            cola  = new Drink("Softdrink", 4.5, 8, false);
            fanta = new Drink("Softdrink", 3.9, 7, false);
            bier  = new Drink("Light",     6.5, 8, true);

            s.addProduct(cola);
            s.addProduct(fanta);
            s.addProduct(bier);
            s.discount5();
            assertEquals(4.275, cola.getPrice(),  0.1);
            assertEquals(3.705, fanta.getPrice(), 0.1);
            assertEquals(6.5,   bier.getPrice(),  0.1);
        }
        catch (ProductException e)
        {
            System.out.println(e.getMessage());
            assertEquals(1,2);
        }
    }

    @Test
    public void testDeleteLightEmpty()
    {
        Shop s;

        s = new Shop();
        try
        {
            s.deleteLight();
            assertEquals(1,2);
        }
        catch (ProductException e)
        {
            System.out.println(e.getMessage());
            assertEquals("Fehler: kein Light Produkt gefunden!",e.getMessage());
        }
    }

    @Test
    public void testDeleteLightNotFound()
    {
        Shop s;
        Drink cola, fanta;

        s = new Shop();
        try
        {
            cola  = new Drink("Softdrink", 4.5, 8, false);
            fanta = new Drink("Softdrink", 3.9, 7, false);

            assertEquals(false, s.containsProduct(cola));
            assertEquals(false, s.containsProduct(fanta));

            s.addProduct(cola);
            s.addProduct(fanta);
            s.deleteLight();
            assertEquals(1,2);
        }
        catch (ProductException e)
        {
            System.out.println(e.getMessage());
            assertEquals("Fehler: kein Light Produkt gefunden!",e.getMessage());
        }
    }

    @Test
    public void testDeleteLight()
    {
        Shop s;
        Drink cola, fanta, bier, wein, vodka;

        s = new Shop();
        try
        {
            cola  = new Drink("Softdrink", 4.5, 8, false);
            fanta = new Drink("Softdrink", 3.9, 7, false);
            bier  = new Drink("Light",     6.5, 8, true);
            wein  = new Drink("Light",     7.5, 8, true);
            vodka = new Drink("Hard",      7.5, 8, true);

            assertEquals(false, s.containsProduct(cola));
            assertEquals(false, s.containsProduct(fanta));
            assertEquals(false, s.containsProduct(bier));
            assertEquals(false, s.containsProduct(wein));
            assertEquals(false, s.containsProduct(vodka));

            s.addProduct(cola);
            s.addProduct(bier);
            s.addProduct(fanta);
            s.addProduct(wein);
            s.addProduct(vodka);
            assertEquals(true, s.containsProduct(cola));
            assertEquals(true, s.containsProduct(fanta));
            assertEquals(true, s.containsProduct(bier));
            assertEquals(true, s.containsProduct(wein));
            assertEquals(true, s.containsProduct(vodka));
            s.deleteLight();
            assertEquals(true, s.containsProduct(cola));
            assertEquals(true, s.containsProduct(fanta));
            assertEquals(false, s.containsProduct(bier));
            assertEquals(false, s.containsProduct(wein));
            assertEquals(true, s.containsProduct(vodka));
        }
        catch (ProductException e)
        {
            System.out.println(e.getMessage());
            assertEquals(1,2);
        }
    }
}