import java.util.ArrayList;
import java.util.Iterator;

public class Shop
{
    private ArrayList<Product> products;

    public Shop()
    {
        products = new ArrayList<>();
    }

    public void addProduct(Product newProduct) throws ProductException
    {
        if (newProduct == null)
            throw new ProductException("Fehler: kein Produkt!");
        if (products.contains(newProduct))
            throw new ProductException("Fehler: das Produkt gibt es bereits!");

        products.add(newProduct);
    }

    public boolean containsProduct(Product p)
    {
        return products.contains(p);
    }

    public void deleteLight() throws ProductException
    {
        Iterator<Product> it;
        Product p;
        boolean found;

        found = false;
        it = products.iterator();
        while (it.hasNext())
        {
            p = it.next();
            if (p.getProductType().equals("Light"))
            {
                found = true;
                it.remove();
            }
        }
        if (found == false)
            throw new ProductException("Fehler: kein Light Produkt gefunden!");
    }

    /*
    public void deleteLight()
    {
        Iterator<Product> it;
        Product p;

        it = products.iterator();
        while (it.hasNext())
        {
            p = it.next();
            if (p.getProductType().equals("Light"))
            {
                it.remove();
            }
        }
    }*/

    public void discount5() throws ProductException
    {
        for (Product p : products)
        {
            if ((p instanceof Drink) && ((Drink) p).isAlcohol()==false)
            {
                p.setPrice(p.getPrice()*0.95);
            }
        }
    }

    public double getSumStockValue()
    {
        double sum;

        sum = 0;
        for (Product p : products)
        {
            sum += p.getStockValue();
        }
        return sum;
    }
}
