public class Auto extends Fahrzeug {
    private boolean anhangerKupplung;

    public Auto(String hersteller, int ps, boolean zulassung, boolean anhangerKupplung) throws FahrzeugException {
        /*
        setHersteller (hersteller);
        setPs (ps);
        setZulassung (zulassung);
        */
        super(hersteller, ps, zulassung);
        setAnhangerKupplung (anhangerKupplung);
    }

    public Auto(boolean anhangerKupplung) throws FahrzeugException {
        super();
        setAnhangerKupplung (anhangerKupplung);
    }

    public Auto() throws FahrzeugException {
        super();
        setAnhangerKupplung(false);
    }

    public boolean isAnhangerKupplung() {
        return anhangerKupplung;
    }

    public void setAnhangerKupplung(boolean anhangerKupplung) {
        this.anhangerKupplung = anhangerKupplung;
    }

    @Override
    public void setPs(int ps) throws FahrzeugException {
        if ((ps >= 70) && (ps <= 200)) {
            this.ps = ps;
        }
        else {
            throw new FahrzeugException("Fehler: ungültige PS Anzahl! Bei einem Auto muss diese zw. 70 und 200 liegen!");
        }
    }

    @Override
    public String toString() {
        if (anhangerKupplung)
            return super.toString() + " mit Kupplung";
        else
            return super.toString() + " ohne Kupplung";
    }
}
