import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

public class FirmaTest {

    @Test
    public void testHinzufugenOK() {
        Firma firma;
        Mitarbeiter m1  = new Mitarbeiter("Anna",   2018, true);
        Mitarbeiter m2  = new Mitarbeiter("Bernd",  2020, false);
        Mitarbeiter m3  = new Mitarbeiter("Clara",  2015, true);
        Mitarbeiter m4  = new Mitarbeiter("David",  2022, false);
        Mitarbeiter m5  = new Mitarbeiter("Eva",    2019, true);
        Mitarbeiter m6  = new Mitarbeiter("Felix",  2017, true);
        Mitarbeiter m7  = new Mitarbeiter("Gina",   2021, false);
        Mitarbeiter m8  = new Mitarbeiter("Hans",   2016, true);
        Mitarbeiter m9  = new Mitarbeiter("Iris",   2014, false);
        Mitarbeiter m10 = new Mitarbeiter("Jonas",  2023, true);

        firma = new Firma();
        firma.hinzufugen(m1);
        firma.hinzufugen(m2);
        firma.hinzufugen(m3);
        System.out.println(firma);
    }

    @Test
    public void testHinzufugenDoppelt() {
        Firma firma;
        Mitarbeiter m1  = new Mitarbeiter("Anna",   2018, true);
        Mitarbeiter m2  = new Mitarbeiter("Bernd",  2020, false);
        Mitarbeiter m3  = new Mitarbeiter("Clara",  2015, true);
        Mitarbeiter m4  = new Mitarbeiter("David",  2022, false);
        Mitarbeiter m5  = new Mitarbeiter("Eva",    2019, true);
        Mitarbeiter m6  = new Mitarbeiter("Felix",  2017, true);
        Mitarbeiter m7  = new Mitarbeiter("Gina",   2021, false);
        Mitarbeiter m8  = new Mitarbeiter("Hans",   2016, true);
        Mitarbeiter m9  = new Mitarbeiter("Iris",   2014, false);
        Mitarbeiter m10 = new Mitarbeiter("Jonas",  2023, true);

        firma = new Firma();
        firma.hinzufugen(m1);
        firma.hinzufugen(m2);
        firma.hinzufugen(m1);
        System.out.println(firma);
    }

    @Test
    public void testHinzufugenNull() {
        Firma firma;
        Mitarbeiter m1  = new Mitarbeiter("Anna",   2018, true);
        Mitarbeiter m2  = new Mitarbeiter("Bernd",  2020, false);
        Mitarbeiter m3  = new Mitarbeiter("Clara",  2015, true);
        Mitarbeiter m4  = new Mitarbeiter("David",  2022, false);
        Mitarbeiter m5  = new Mitarbeiter("Eva",    2019, true);
        Mitarbeiter m6  = new Mitarbeiter("Felix",  2017, true);
        Mitarbeiter m7  = new Mitarbeiter("Gina",   2021, false);
        Mitarbeiter m8  = new Mitarbeiter("Hans",   2016, true);
        Mitarbeiter m9  = new Mitarbeiter("Iris",   2014, false);
        Mitarbeiter m10 = new Mitarbeiter("Jonas",  2023, true);

        firma = new Firma();
        firma.hinzufugen(null);
        System.out.println(firma);
    }

    @Test
    public void testHinzufugen10() {
        Firma firma;
        Mitarbeiter m1  = new Mitarbeiter("Anna",   2018, true);
        Mitarbeiter m2  = new Mitarbeiter("Bernd",  2020, false);
        Mitarbeiter m3  = new Mitarbeiter("Clara",  2015, true);
        Mitarbeiter m4  = new Mitarbeiter("David",  2022, false);
        Mitarbeiter m5  = new Mitarbeiter("Eva",    2019, true);
        Mitarbeiter m6  = new Mitarbeiter("Felix",  2017, true);
        Mitarbeiter m7  = new Mitarbeiter("Gina",   2021, false);
        Mitarbeiter m8  = new Mitarbeiter("Hans",   2016, true);
        Mitarbeiter m9  = new Mitarbeiter("Iris",   2014, false);
        Mitarbeiter m10 = new Mitarbeiter("Jonas",  2023, true);

        firma = new Firma();
        firma.hinzufugen(m1);
        firma.hinzufugen(m2);
        firma.hinzufugen(m3);
        firma.hinzufugen(m4);
        firma.hinzufugen(m5);
        firma.hinzufugen(m6);
        firma.hinzufugen(m7);
        firma.hinzufugen(m8);
        firma.hinzufugen(m9);
        firma.hinzufugen(m10);
        System.out.println(firma);
    }

    @Test
    public void testHinzufugenPos3() {
        Firma firma;
        Mitarbeiter m1  = new Mitarbeiter("Anna",   2018, true);
        Mitarbeiter m2  = new Mitarbeiter("Bernd",  2020, false);
        Mitarbeiter m3  = new Mitarbeiter("Clara",  2015, true);
        Mitarbeiter m4  = new Mitarbeiter("David",  2022, false);
        Mitarbeiter m5  = new Mitarbeiter("Eva",    2019, true);
        Mitarbeiter m6  = new Mitarbeiter("Felix",  2017, true);
        Mitarbeiter m7  = new Mitarbeiter("Gina",   2021, false);
        Mitarbeiter m8  = new Mitarbeiter("Hans",   2016, true);
        Mitarbeiter m9  = new Mitarbeiter("Iris",   2014, false);
        Mitarbeiter m10 = new Mitarbeiter("Jonas",  2023, true);

        firma = new Firma();
        firma.hinzufugen(m1);
        firma.hinzufugen(m2);
        firma.hinzufugen(m3);
        firma.hinzufugen(m4);
        firma.hinzufugen(m5);
        firma.hinzufugen(m6);
        firma.hinzufugen(m7);
        firma.hinzufugen(m8);
        firma.hinzufugen(m9);
        firma.hinzufugen(m10);
        firma.hinzufugen(3, "Alexander", 2020, true);
        System.out.println(firma);
        assertEquals(m1, firma.get(0));
        assertEquals(m2, firma.get(1));
        assertEquals(m3, firma.get(2));
        assertEquals("Alexander", firma.get(3).getName());
        assertEquals(m4, firma.get(4));
        assertEquals(m5, firma.get(5));
        assertEquals(m6, firma.get(6));
        assertEquals(m7, firma.get(7));
        assertEquals(m8, firma.get(8));
        assertEquals(m9, firma.get(9));
        assertEquals(m10, firma.get(10));
    }

    @Test
    public void testHinzufugenPosNegativ() {
        Firma firma;
        Mitarbeiter m1  = new Mitarbeiter("Anna",   2018, true);
        Mitarbeiter m2  = new Mitarbeiter("Bernd",  2020, false);
        Mitarbeiter m3  = new Mitarbeiter("Clara",  2015, true);
        Mitarbeiter m4  = new Mitarbeiter("David",  2022, false);
        Mitarbeiter m5  = new Mitarbeiter("Eva",    2019, true);
        Mitarbeiter m6  = new Mitarbeiter("Felix",  2017, true);
        Mitarbeiter m7  = new Mitarbeiter("Gina",   2021, false);
        Mitarbeiter m8  = new Mitarbeiter("Hans",   2016, true);
        Mitarbeiter m9  = new Mitarbeiter("Iris",   2014, false);
        Mitarbeiter m10 = new Mitarbeiter("Jonas",  2023, true);

        firma = new Firma();
        firma.hinzufugen(m1);
        firma.hinzufugen(m2);
        firma.hinzufugen(m3);
        firma.hinzufugen(m4);
        firma.hinzufugen(m5);
        firma.hinzufugen(m6);
        firma.hinzufugen(m7);
        firma.hinzufugen(m8);
        firma.hinzufugen(m9);
        firma.hinzufugen(m10);
        System.out.println(firma);
        firma.hinzufugen(-1, "Alexander", 2020, true);
        System.out.println(firma);
    }


    @Test
    public void testHinzufugenPosGross() {
        Firma firma;
        Mitarbeiter m1  = new Mitarbeiter("Anna",   2018, true);
        Mitarbeiter m2  = new Mitarbeiter("Bernd",  2020, false);
        Mitarbeiter m3  = new Mitarbeiter("Clara",  2015, true);
        Mitarbeiter m4  = new Mitarbeiter("David",  2022, false);
        Mitarbeiter m5  = new Mitarbeiter("Eva",    2019, true);
        Mitarbeiter m6  = new Mitarbeiter("Felix",  2017, true);
        Mitarbeiter m7  = new Mitarbeiter("Gina",   2021, false);
        Mitarbeiter m8  = new Mitarbeiter("Hans",   2016, true);
        Mitarbeiter m9  = new Mitarbeiter("Iris",   2014, false);
        Mitarbeiter m10 = new Mitarbeiter("Jonas",  2023, true);

        firma = new Firma();
        firma.hinzufugen(m1);
        firma.hinzufugen(m2);
        firma.hinzufugen(m3);
        firma.hinzufugen(m4);
        firma.hinzufugen(m5);
        firma.hinzufugen(m6);
        firma.hinzufugen(m7);
        firma.hinzufugen(m8);
        firma.hinzufugen(m9);
        firma.hinzufugen(m10);
        System.out.println(firma);
        firma.hinzufugen(11, "Alexander", 2020, true);
        System.out.println(firma);
    }


    @Test
    public void testLoscheAnna() {
        Firma firma;
        Mitarbeiter m1  = new Mitarbeiter("Anna",   2018, true);
        Mitarbeiter m2  = new Mitarbeiter("Max",    2020, false);
        Mitarbeiter m3  = new Mitarbeiter("Clara",  2015, true);
        Mitarbeiter m4  = new Mitarbeiter("David",  2022, false);
        Mitarbeiter m5  = new Mitarbeiter("Max",    2019, true);
        Mitarbeiter m6  = new Mitarbeiter("Felix",  2017, true);
        Mitarbeiter m7  = new Mitarbeiter("Anna",   2021, false);
        Mitarbeiter m8  = new Mitarbeiter("Max",    2016, true);
        Mitarbeiter m9  = new Mitarbeiter("Iris",   2014, false);
        Mitarbeiter m10 = new Mitarbeiter("Jonas",  2023, true);

        firma = new Firma();
        firma.hinzufugen(m1);
        firma.hinzufugen(m2);
        firma.hinzufugen(m3);
        firma.hinzufugen(m4);
        firma.hinzufugen(m5);
        firma.hinzufugen(m6);
        firma.hinzufugen(m7);
        firma.hinzufugen(m8);
        firma.hinzufugen(m9);
        firma.hinzufugen(m10);
        firma.losche("Anna");
        System.out.println(firma);
        assertEquals(m2, firma.get(0));
        assertEquals(m3, firma.get(1));
        assertEquals(m4, firma.get(2));
        assertEquals(m5, firma.get(3));
        assertEquals(m6, firma.get(4));
        assertEquals(m8, firma.get(5));
        assertEquals(m9, firma.get(6));
        assertEquals(m10, firma.get(7));
    }


    @Test
    public void testLoscheMax() {
        Firma firma;
        Mitarbeiter m1  = new Mitarbeiter("Anna",   2018, true);
        Mitarbeiter m2  = new Mitarbeiter("Max",    2020, false);
        Mitarbeiter m3  = new Mitarbeiter("Clara",  2015, true);
        Mitarbeiter m4  = new Mitarbeiter("David",  2022, false);
        Mitarbeiter m5  = new Mitarbeiter("Max",    2019, true);
        Mitarbeiter m6  = new Mitarbeiter("Felix",  2017, true);
        Mitarbeiter m7  = new Mitarbeiter("Anna",   2021, false);
        Mitarbeiter m8  = new Mitarbeiter("Max",    2016, true);
        Mitarbeiter m9  = new Mitarbeiter("Iris",   2014, false);
        Mitarbeiter m10 = new Mitarbeiter("Jonas",  2023, true);

        firma = new Firma();
        firma.hinzufugen(m1);
        firma.hinzufugen(m2);
        firma.hinzufugen(m3);
        firma.hinzufugen(m4);
        firma.hinzufugen(m5);
        firma.hinzufugen(m6);
        firma.hinzufugen(m7);
        firma.hinzufugen(m8);
        firma.hinzufugen(m9);
        firma.hinzufugen(m10);
        firma.losche("Max");
        System.out.println(firma);
        assertEquals(m1, firma.get(0));
        assertEquals(m3, firma.get(1));
        assertEquals(m4, firma.get(2));
        assertEquals(m6, firma.get(3));
        assertEquals(m7, firma.get(4));
        assertEquals(m9, firma.get(5));
        assertEquals(m10, firma.get(6));
    }
}