import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

class HandlerTest {
    @Test
    public void testLoschenHersteller() {
        Handler handler = new Handler();
        Fahrzeug a = new Fahrzeug("BMW",      150, true);
        Fahrzeug b = new Fahrzeug("Audi",     180, true);
        Fahrzeug c = new Fahrzeug("Mercedes", 200, true);
        Fahrzeug d = new Fahrzeug("BMW",      120, true);
        Fahrzeug e = new Fahrzeug("Opel",      90, false);
        Fahrzeug f = new Fahrzeug("Toyota",   110, true);
        Fahrzeug g = new Fahrzeug("BMW",       95, false);
        Fahrzeug h = new Fahrzeug("Ford",     140, true);
        Fahrzeug i = new Fahrzeug("Porsche",  400, true);
        Fahrzeug j = new Fahrzeug("Tesla",    300, true);

        System.out.println(handler);
        System.out.println("=====================");
        handler.hinzufugen(a);
        handler.hinzufugen(b);
        handler.hinzufugen(c);
        handler.hinzufugen(d);
        handler.hinzufugen(e);
        handler.hinzufugen(f);
        handler.hinzufugen(g);
        handler.hinzufugen(h);
        handler.hinzufugen(i);
        handler.hinzufugen(j);
        assertTrue(handler.contains(a));
        assertTrue(handler.contains(b));
        assertTrue(handler.contains(c));
        assertTrue(handler.contains(d));
        assertTrue(handler.contains(e));
        assertTrue(handler.contains(f));
        assertTrue(handler.contains(g));
        assertTrue(handler.contains(h));
        assertTrue(handler.contains(i));
        assertTrue(handler.contains(j));
        handler.losche("VW");
        System.out.println(handler);
        assertTrue(handler.contains(a));
        assertTrue(handler.contains(b));
        assertTrue(handler.contains(c));
        assertTrue(handler.contains(d));
        assertTrue(handler.contains(e));
        assertTrue(handler.contains(f));
        assertTrue(handler.contains(g));
        assertTrue(handler.contains(h));
        assertTrue(handler.contains(i));
        assertTrue(handler.contains(j));
        System.out.println("=====================");
        handler.losche("BMW");
        assertFalse(handler.contains(a));
        assertTrue(handler.contains(b));
        assertTrue(handler.contains(c));
        assertFalse(handler.contains(d));
        assertTrue(handler.contains(e));
        assertTrue(handler.contains(f));
        assertFalse(handler.contains(g));
        assertTrue(handler.contains(h));
        assertTrue(handler.contains(i));
        assertTrue(handler.contains(j));
        System.out.println(handler);
    }

    @Test
    public void testHinzufugen() {
        Handler handler = new Handler();
        Fahrzeug a = new Fahrzeug("BMW", 150, true);
        Fahrzeug b = new Fahrzeug("Audi", 180, true);
        Fahrzeug c = new Fahrzeug("Mercedes", 200, true);
        Fahrzeug d = new Fahrzeug("Volkswagen", 120, true);
        Fahrzeug e = new Fahrzeug("Opel", 90, false);
        Fahrzeug f = new Fahrzeug("Toyota", 110, true);
        Fahrzeug g = new Fahrzeug("Honda", 95, false);
        Fahrzeug h = new Fahrzeug("Ford", 140, true);
        Fahrzeug i = new Fahrzeug("Porsche", 400, true);
        Fahrzeug j = new Fahrzeug("Tesla", 300, true);

        System.out.println(handler);
        System.out.println("=====================");
        handler.hinzufugen(a);
        handler.hinzufugen(b);
        handler.hinzufugen(c);
        handler.hinzufugen(d);
        handler.hinzufugen(e);
        // Fehler
        handler.hinzufugen(a);
        // BMW Audi Mercedes Volkswagen Opel
        System.out.println(handler);
    }

    @Test
    public void testMaxPs() {
        Handler handler = new Handler();
        Fahrzeug a = new Fahrzeug("BMW", 150, true);
        Fahrzeug b = new Fahrzeug("Audi", 180, true);
        Fahrzeug c = new Fahrzeug("Mercedes", 200, true);
        Fahrzeug d = new Fahrzeug("Volkswagen", 120, true);
        Fahrzeug e = new Fahrzeug("Opel", 90, false);
        Fahrzeug f = new Fahrzeug("Toyota", 110, true);
        Fahrzeug g = new Fahrzeug("Honda", 95, false);
        Fahrzeug h = new Fahrzeug("Ford", 140, true);
        Fahrzeug i = new Fahrzeug("Porsche", 400, true);
        Fahrzeug j = new Fahrzeug("Tesla", 300, true);

        System.out.println(handler);
        assertNull(handler.maxPs());
        handler.hinzufugen(a);
        handler.hinzufugen(b);
        handler.hinzufugen(c);
        handler.hinzufugen(d);
        assertEquals(c, handler.maxPs());
    }
}