import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

class HandlerTest {
    @Test
    public void testLoschenHersteller() {
        Handler handler = new Handler();
        Fahrzeug a = new Fahrzeug("BMW",      150, true);
        Fahrzeug b = new Fahrzeug("Audi",     180, true);
        Fahrzeug c = new Fahrzeug("Mercedes", 200, true);
        Fahrzeug d = new Fahrzeug("BMW",      120, true);
        Fahrzeug e = new Fahrzeug("Opel",      90, false);
        Fahrzeug f = new Fahrzeug("Toyota",   110, true);
        Fahrzeug g = new Fahrzeug("BMW",       95, false);
        Fahrzeug h = new Fahrzeug("Ford",     140, true);
        Fahrzeug i = new Fahrzeug("Porsche",  400, true);
        Fahrzeug j = new Fahrzeug("Tesla",    300, true);

        System.out.println(handler);
        System.out.println("=====================");
        handler.hinzufugen(a);
        handler.hinzufugen(b);
        handler.hinzufugen(c);
        handler.hinzufugen(d);
        handler.hinzufugen(e);
        handler.hinzufugen(f);
        handler.hinzufugen(g);
        handler.hinzufugen(h);
        handler.hinzufugen(i);
        handler.hinzufugen(j);
        assertTrue(handler.contains(a));
        assertTrue(handler.contains(b));
        assertTrue(handler.contains(c));
        assertTrue(handler.contains(d));
        assertTrue(handler.contains(e));
        assertTrue(handler.contains(f));
        assertTrue(handler.contains(g));
        assertTrue(handler.contains(h));
        assertTrue(handler.contains(i));
        assertTrue(handler.contains(j));
        handler.losche("VW");
        System.out.println(handler);
        assertTrue(handler.contains(a));
        assertTrue(handler.contains(b));
        assertTrue(handler.contains(c));
        assertTrue(handler.contains(d));
        assertTrue(handler.contains(e));
        assertTrue(handler.contains(f));
        assertTrue(handler.contains(g));
        assertTrue(handler.contains(h));
        assertTrue(handler.contains(i));
        assertTrue(handler.contains(j));
        System.out.println("=====================");
        handler.losche("BMW");
        assertFalse(handler.contains(a));
        assertTrue(handler.contains(b));
        assertTrue(handler.contains(c));
        assertFalse(handler.contains(d));
        assertTrue(handler.contains(e));
        assertTrue(handler.contains(f));
        assertFalse(handler.contains(g));
        assertTrue(handler.contains(h));
        assertTrue(handler.contains(i));
        assertTrue(handler.contains(j));
        System.out.println(handler);
    }

    @Test
    public void testHinzufugen() {
        Handler handler = new Handler();
        Fahrzeug a = new Fahrzeug("BMW", 150, true);
        Fahrzeug b = new Fahrzeug("Audi", 180, true);
        Fahrzeug c = new Fahrzeug("Mercedes", 200, true);
        Fahrzeug d = new Fahrzeug("Volkswagen", 120, true);
        Fahrzeug e = new Fahrzeug("Opel", 90, false);
        Fahrzeug f = new Fahrzeug("Toyota", 110, true);
        Fahrzeug g = new Fahrzeug("Honda", 95, false);
        Fahrzeug h = new Fahrzeug("Ford", 140, true);
        Fahrzeug i = new Fahrzeug("Porsche", 400, true);
        Fahrzeug j = new Fahrzeug("Tesla", 300, true);

        System.out.println(handler);
        System.out.println("=====================");
        handler.hinzufugen(a);
        handler.hinzufugen(b);
        handler.hinzufugen(c);
        handler.hinzufugen(d);
        handler.hinzufugen(e);
        // Fehler
        handler.hinzufugen(a);
        // BMW Audi Mercedes Volkswagen Opel
        System.out.println(handler);
    }

    @Test
    public void testMaxPs() {
        Handler handler = new Handler();
        Fahrzeug a = new Fahrzeug("BMW", 150, true);
        Fahrzeug b = new Fahrzeug("Audi", 180, true);
        Fahrzeug c = new Fahrzeug("Mercedes", 200, true);
        Fahrzeug d = new Fahrzeug("Volkswagen", 120, true);
        Fahrzeug e = new Fahrzeug("Opel", 90, false);
        Fahrzeug f = new Fahrzeug("Toyota", 110, true);
        Fahrzeug g = new Fahrzeug("Honda", 95, false);
        Fahrzeug h = new Fahrzeug("Ford", 140, true);
        Fahrzeug i = new Fahrzeug("Porsche", 400, true);
        Fahrzeug j = new Fahrzeug("Tesla", 300, true);

        System.out.println(handler);
        assertNull(handler.maxPs());
        handler.hinzufugen(a);
        handler.hinzufugen(b);
        handler.hinzufugen(c);
        handler.hinzufugen(d);
        assertEquals(c, handler.maxPs());
    }

    @Test
    public void testAvgPsOhne() {
        Handler handler = new Handler();
        Fahrzeug a = new Fahrzeug("BMW", 150, true);
        Fahrzeug b = new Fahrzeug("Audi", 180, true);
        Fahrzeug c = new Fahrzeug("Mercedes", 200, true);
        Fahrzeug d = new Fahrzeug("Volkswagen", 120, true);
        Fahrzeug e = new Fahrzeug("Opel", 90, false);
        Fahrzeug f = new Fahrzeug("Toyota", 110, true);
        Fahrzeug g = new Fahrzeug("Honda", 95, false);
        Fahrzeug h = new Fahrzeug("Ford", 140, true);
        Fahrzeug i = new Fahrzeug("Porsche", 400, true);
        Fahrzeug j = new Fahrzeug("Tesla", 300, true);

        System.out.println(handler);
        assertEquals(-999, handler.avgPs(), 0.000001);
    }

    @Test
    public void testAvgPsOK() {
        Handler handler = new Handler();
        Fahrzeug a = new Fahrzeug("BMW", 150, true);
        Fahrzeug b = new Fahrzeug("Audi", 180, true);
        Fahrzeug c = new Fahrzeug("Mercedes", 200, true);
        Fahrzeug d = new Fahrzeug("Volkswagen", 120, true);
        Fahrzeug e = new Fahrzeug("Opel", 90, false);
        Fahrzeug f = new Fahrzeug("Toyota", 110, true);
        Fahrzeug g = new Fahrzeug("Honda", 95, false);
        Fahrzeug h = new Fahrzeug("Ford", 140, true);
        Fahrzeug i = new Fahrzeug("Porsche", 400, true);
        Fahrzeug j = new Fahrzeug("Tesla", 300, true);

        handler.hinzufugen(a);
        assertEquals(150, handler.avgPs(), 0.000001);
        handler.hinzufugen(b);
        assertEquals(165, handler.avgPs(), 0.000001);
        handler.hinzufugen(c);
        handler.hinzufugen(d);
        handler.hinzufugen(e);
        handler.hinzufugen(f);
        handler.hinzufugen(g);
        handler.hinzufugen(h);
        System.out.println(handler);
        assertEquals(135.625, handler.avgPs(), 0.000001);
    }

    @Test
    public void testHinzufugenPosOK() {
        Handler handler = new Handler();
        Fahrzeug a = new Fahrzeug("BMW", 150, true);
        Fahrzeug b = new Fahrzeug("Audi", 180, true);
        Fahrzeug c = new Fahrzeug("Mercedes", 200, true);
        Fahrzeug d = new Fahrzeug("Volkswagen", 120, true);
        Fahrzeug e = new Fahrzeug("Opel", 90, false);
        Fahrzeug f = new Fahrzeug("Toyota", 110, true);
        Fahrzeug g = new Fahrzeug("Honda", 95, false);
        Fahrzeug h = new Fahrzeug("Ford", 140, true);
        Fahrzeug i = new Fahrzeug("Porsche", 400, true);
        Fahrzeug j = new Fahrzeug("Tesla", 300, true);

        handler.hinzufugen(a);
        handler.hinzufugen(b);
        handler.hinzufugen(c);
        handler.hinzufugen(d);
        handler.hinzufugen(e);
        handler.hinzufugen(f);
        handler.hinzufugen(g);
        handler.hinzufugen(h);
        handler.hinzufugen(3, i);
        assertEquals(a, handler.getFahrzeug(0));
        assertEquals(b, handler.getFahrzeug(1));
        assertEquals(c, handler.getFahrzeug(2));
        assertEquals(i, handler.getFahrzeug(3));
        assertEquals(d, handler.getFahrzeug(4));
        assertEquals(e, handler.getFahrzeug(5));
        assertEquals(f, handler.getFahrzeug(6));
        assertEquals(g, handler.getFahrzeug(7));
        assertEquals(h, handler.getFahrzeug(8));
    }

    @Test
    public void testHinzufugenPos0() {
        Handler handler = new Handler();
        Fahrzeug a = new Fahrzeug("BMW", 150, true);
        Fahrzeug b = new Fahrzeug("Audi", 180, true);
        Fahrzeug c = new Fahrzeug("Mercedes", 200, true);
        Fahrzeug d = new Fahrzeug("Volkswagen", 120, true);
        Fahrzeug e = new Fahrzeug("Opel", 90, false);
        Fahrzeug f = new Fahrzeug("Toyota", 110, true);
        Fahrzeug g = new Fahrzeug("Honda", 95, false);
        Fahrzeug h = new Fahrzeug("Ford", 140, true);
        Fahrzeug i = new Fahrzeug("Porsche", 400, true);
        Fahrzeug j = new Fahrzeug("Tesla", 300, true);

        handler.hinzufugen(a);
        handler.hinzufugen(b);
        handler.hinzufugen(c);
        handler.hinzufugen(d);
        handler.hinzufugen(e);
        handler.hinzufugen(f);
        handler.hinzufugen(g);
        handler.hinzufugen(h);
        handler.hinzufugen(0, i);
        assertEquals(i, handler.getFahrzeug(0));
        assertEquals(a, handler.getFahrzeug(1));
        assertEquals(b, handler.getFahrzeug(2));
        assertEquals(c, handler.getFahrzeug(3));
        assertEquals(d, handler.getFahrzeug(4));
        assertEquals(e, handler.getFahrzeug(5));
        assertEquals(f, handler.getFahrzeug(6));
        assertEquals(g, handler.getFahrzeug(7));
        assertEquals(h, handler.getFahrzeug(8));
    }

    @Test
    public void testHinzufugenPosEnde() {
        Handler handler = new Handler();
        Fahrzeug a = new Fahrzeug("BMW", 150, true);
        Fahrzeug b = new Fahrzeug("Audi", 180, true);
        Fahrzeug c = new Fahrzeug("Mercedes", 200, true);
        Fahrzeug d = new Fahrzeug("Volkswagen", 120, true);
        Fahrzeug e = new Fahrzeug("Opel", 90, false);
        Fahrzeug f = new Fahrzeug("Toyota", 110, true);
        Fahrzeug g = new Fahrzeug("Honda", 95, false);
        Fahrzeug h = new Fahrzeug("Ford", 140, true);
        Fahrzeug i = new Fahrzeug("Porsche", 400, true);
        Fahrzeug j = new Fahrzeug("Tesla", 300, true);

        handler.hinzufugen(a);
        handler.hinzufugen(b);
        handler.hinzufugen(c);
        handler.hinzufugen(d);
        handler.hinzufugen(e);
        handler.hinzufugen(f);
        handler.hinzufugen(g);
        handler.hinzufugen(h);
        handler.hinzufugen(8, i);
        assertEquals(a, handler.getFahrzeug(0));
        assertEquals(b, handler.getFahrzeug(1));
        assertEquals(c, handler.getFahrzeug(2));
        assertEquals(d, handler.getFahrzeug(3));
        assertEquals(e, handler.getFahrzeug(4));
        assertEquals(f, handler.getFahrzeug(5));
        assertEquals(g, handler.getFahrzeug(6));
        assertEquals(h, handler.getFahrzeug(7));
        assertEquals(i, handler.getFahrzeug(8));
    }

    @Test
    public void testHinzufugenPosMinus() {
        Handler handler = new Handler();
        Fahrzeug a = new Fahrzeug("BMW", 150, true);
        Fahrzeug b = new Fahrzeug("Audi", 180, true);
        Fahrzeug c = new Fahrzeug("Mercedes", 200, true);
        Fahrzeug d = new Fahrzeug("Volkswagen", 120, true);
        Fahrzeug e = new Fahrzeug("Opel", 90, false);
        Fahrzeug f = new Fahrzeug("Toyota", 110, true);
        Fahrzeug g = new Fahrzeug("Honda", 95, false);
        Fahrzeug h = new Fahrzeug("Ford", 140, true);
        Fahrzeug i = new Fahrzeug("Porsche", 400, true);
        Fahrzeug j = new Fahrzeug("Tesla", 300, true);

        handler.hinzufugen(a);
        handler.hinzufugen(b);
        handler.hinzufugen(c);
        handler.hinzufugen(d);
        handler.hinzufugen(e);
        handler.hinzufugen(f);
        handler.hinzufugen(g);
        handler.hinzufugen(h);
        handler.hinzufugen(-2, i);
        assertEquals(a, handler.getFahrzeug(0));
        assertEquals(b, handler.getFahrzeug(1));
        assertEquals(c, handler.getFahrzeug(2));
        assertEquals(d, handler.getFahrzeug(3));
        assertEquals(e, handler.getFahrzeug(4));
        assertEquals(f, handler.getFahrzeug(5));
        assertEquals(g, handler.getFahrzeug(6));
        assertEquals(h, handler.getFahrzeug(7));
    }

    @Test
    public void testHinzufugenPosEndePlus1() {

        Handler handler = new Handler();
        Fahrzeug a = new Fahrzeug("BMW", 150, true);
        Fahrzeug b = new Fahrzeug("Audi", 180, true);
        Fahrzeug c = new Fahrzeug("Mercedes", 200, true);
        Fahrzeug d = new Fahrzeug("Volkswagen", 120, true);
        Fahrzeug e = new Fahrzeug("Opel", 90, false);
        Fahrzeug f = new Fahrzeug("Toyota", 110, true);
        Fahrzeug g = new Fahrzeug("Honda", 95, false);
        Fahrzeug h = new Fahrzeug("Ford", 140, true);
        Fahrzeug i = new Fahrzeug("Porsche", 400, true);
        Fahrzeug j = new Fahrzeug("Tesla", 300, true);

        handler.hinzufugen(a);
        handler.hinzufugen(b);
        handler.hinzufugen(c);
        handler.hinzufugen(d);
        handler.hinzufugen(e);
        handler.hinzufugen(f);
        handler.hinzufugen(g);
        handler.hinzufugen(h);
        handler.hinzufugen(9, i);
        assertEquals(a, handler.getFahrzeug(0));
        assertEquals(b, handler.getFahrzeug(1));
        assertEquals(c, handler.getFahrzeug(2));
        assertEquals(d, handler.getFahrzeug(3));
        assertEquals(e, handler.getFahrzeug(4));
        assertEquals(f, handler.getFahrzeug(5));
        assertEquals(g, handler.getFahrzeug(6));
        assertEquals(h, handler.getFahrzeug(7));
    }

}