import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.*;

class SchoolTest2
{
    @Test
    public void testAvgAlter()
    {
        School s;
        Student max, susi, werner, karl;

        s = new School();
        max    = new Student("Max",    29, true);
        susi   = new Student("Susi",   22, true);
        werner = new Student("Werner", 17, false);
        karl   = new Student("Karl",   19, false);

        assertEquals(-999, s.avgAlter(), 0.1);

        s.aufnehmen(max);
        assertEquals(29, s.avgAlter(), 0.1);

        s.aufnehmen(susi);
        assertEquals(25.5, s.avgAlter(), 0.1);

        s.aufnehmen(werner);
        assertEquals(22.666666, s.avgAlter(), 0.1);

        s.aufnehmen(karl);
        assertEquals(21.75, s.avgAlter(), 0.1);
    }

    @Test
    public void testAufnehmen()
    {
        School s;
        Student max, susi, werner, karl, andrea;

        s = new School();
        max    = new Student("Max",    29, true);
        susi   = new Student("Susi",   22, true);
        werner = new Student("Werner", 17, false);
        karl   = new Student("Karl",   19, false);
        andrea = new Student("Andrea", 33, true);

        System.out.println(s);
        System.out.println("======================");

        s.aufnehmen(null);  //Fehler kein Student
        System.out.println(s);
        System.out.println("======================");

        s.aufnehmen(max);
        System.out.println(s);
        System.out.println("======================");     // Max

        s.aufnehmen(susi);
        System.out.println(s);
        System.out.println("======================");     // Max Susi

        s.aufnehmen(werner);
        System.out.println(s);
        System.out.println("======================");     // Max Susi Werner

        s.aufnehmen(karl);
        System.out.println(s);
        System.out.println("======================");     // Max Susi Werner Karl

        s.aufnehmen(andrea);
        System.out.println(s);
        System.out.println("======================");     // Max Susi Werner Karl Andrea

        s.aufnehmen(max);                                 // Fehler schon in der Schule
        System.out.println(s);
        System.out.println("======================");     // Max Susi Werner Karl Andrea
    }

    @Test
    public void testMaxAlter()
    {
        School s;
        Student max, susi, werner, karl, andrea;

        s = new School();
        max    = new Student("Max",    25, true);
        susi   = new Student("Susi",   22, true);
        werner = new Student("Werner", 29, true);
        karl   = new Student("Karl",   19, false);
        andrea = new Student("Andrea", 29, true);

        assertEquals(null, s.maxAlter());

        s.aufnehmen(max);
        assertEquals(max, s.maxAlter());

        s.aufnehmen(susi);
        assertEquals(max, s.maxAlter());

        s.aufnehmen(werner);
        assertEquals(werner, s.maxAlter());

        s.aufnehmen(karl);
        assertEquals(werner, s.maxAlter());

        s.aufnehmen(andrea);
        assertEquals(werner, s.maxAlter());
    }
}